/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.coremods;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import net.neoforged.neoforgespi.transformation.SimpleMethodProcessor;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceFieldComparisonWithInstanceOf
extends SimpleMethodProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceFieldComparisonWithInstanceOf.class);
    private final Set<SimpleMethodProcessor.Target> targets;
    private final String fieldOwner;
    private final String fieldName;
    private final String replacementClassName;

    public ReplaceFieldComparisonWithInstanceOf(String fieldOwner, String fieldName, String replacementClassName, List<SimpleMethodProcessor.Target> methodsToScan) {
        this.targets = Set.copyOf(methodsToScan);
        this.fieldOwner = fieldOwner;
        this.fieldName = fieldName;
        this.replacementClassName = replacementClassName;
    }

    public ProcessorName name() {
        String owner = this.fieldOwner.toLowerCase(Locale.ROOT).replace('$', '.');
        String name = this.fieldName.toLowerCase(Locale.ROOT);
        return new ProcessorName("neoforge.coremods", "field_comparison_to_instanceof." + owner + "." + name);
    }

    public Set<SimpleMethodProcessor.Target> targets() {
        return this.targets;
    }

    public void transform(MethodNode methodNode, SimpleTransformationContext context) {
        int count = 0;
        for (AbstractInsnNode node = methodNode.instructions.getFirst(); node != null; node = node.getNext()) {
            FieldInsnNode fieldAccessNode;
            AbstractInsnNode abstractInsnNode;
            JumpInsnNode jumpNode;
            if (!(node instanceof JumpInsnNode) || (jumpNode = (JumpInsnNode)node).getOpcode() != 165 && jumpNode.getOpcode() != 166 || !((abstractInsnNode = node.getPrevious()) instanceof FieldInsnNode) || (fieldAccessNode = (FieldInsnNode)abstractInsnNode).getOpcode() != 178 && fieldAccessNode.getOpcode() != 180 || !fieldAccessNode.owner.equals(this.fieldOwner) || !fieldAccessNode.name.equals(this.fieldName)) continue;
            methodNode.instructions.set((AbstractInsnNode)fieldAccessNode, (AbstractInsnNode)new TypeInsnNode(193, this.replacementClassName));
            methodNode.instructions.set((AbstractInsnNode)jumpNode, (AbstractInsnNode)new JumpInsnNode(jumpNode.getOpcode() == 165 ? 154 : 153, jumpNode.label));
            ++count;
        }
        LOG.trace("Transforming: {}.", (Object)methodNode.name);
        LOG.trace("field_to_instance: Replaced {} checks", (Object)count);
    }
}

